/**
* \file: PoolTemplate.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_POOLTEMPLATE_H
#define CARPLAY_POOLTEMPLATE_H

#include "Common.h"
#include <vector>

namespace adit { namespace carplay
{

template <class TItemType, int TWarningSize>
class CARPLAY_HIDDEN PoolTemplate
{
public:
    PoolTemplate()
    {
        poolWarning = TWarningSize;
    }

    ~PoolTemplate()
    {
        for (auto item : pool)
            delete item;
    }

    TItemType* Take()
    {
        // pool in general should not grow larger than 3-5 items
        // look up is more costly this way for long lists,
        // but holding track of free items implies locking
        for (auto item : pool)
        {
            if (item->IsFree())
            {
                item->Take();
                return item;
            }
        }

        auto item = new TItemType();
        item->Take();
        pool.push_back(item);

        if (poolWarning > 0 && pool.size() >= (size_t)poolWarning)
        {
            LOG_WARN((dipo, "Pool has grown to %d items! Release call missing?!", poolWarning));
            poolWarning *= 2;
        }

        return item;
    }

private:
    std::vector<TItemType*> pool;

    int poolWarning;
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_POOLTEMPLATE_H */
